package editor;

import game.CustomImageDataII;
import game.IntRect;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.ImageObserver;
import java.io.File;
import java.util.ArrayList;

public class RogueBlockScreenPaletteObject extends ScreenPaletteObject {
	
	
	private boolean shouldBePassThru;
	private int desiredWidth;
	private int desiredHeight;
	private String fileName;

	private ArrayList<ScreenObject> allCreatedObjects;
	
	public RogueBlockScreenPaletteObject(IntRect theClickRect, int theDistanceToBorder, int theBorderWidth, ImageObserver io, int width, int height, String imageFileName, Color transparentColor, boolean passThru, String theFileName) {
		
		shouldBePassThru = passThru;
		fileName = theFileName;
		clickRect = theClickRect;
		
//		System.out.println("imageFileName is: " + imageFileName);
		
		image = new CustomImageDataII(new File(imageFileName), transparentColor, io, width, height);
		
		distanceToBorder = theDistanceToBorder;
		borderWidth = theBorderWidth;
		
		desiredWidth = width;
		desiredHeight = height;
		
		allCreatedObjects = new ArrayList<ScreenObject>();
		
//		System.out.println(">>>>>>>>>>>>>  width: " + desiredWidth + ", height: " + height + ", theClickRect.minx: " + theClickRect.getMinX() + " maxX " + theClickRect.getMaxX() + " minY " + theClickRect.getMinY() + " maxY " + theClickRect.getMaxY());
		
	}
	
	
	
	
	
	
	@Override
	public ScreenObject create(int objX, int objY, ImageObserver io) {
		RogueBlockScreenObject returnValue = new RogueBlockScreenObject(objX, objY, desiredWidth, desiredHeight, this, shouldBePassThru, clickRect);
		allCreatedObjects.add(returnValue);
		
		return returnValue;
	}

	@Override
	public void draw(Graphics g) {
		
		if(clickRect == null)
			return;
		
		Point p = clickRect.getCenter();
		
//		System.out.println("about to draw image for rogue block palette object at " + p.x + ", " + p.y + ", is the image null? " + (image.getImage() == null));
		
		image.drawObjectFromUpperLeftCorner(g, clickRect.getMinX(), clickRect.getMinY());
		
		Color origCol = g.getColor();
		
		if(isSelected) {
			g.setColor(new Color(255, 200, 0));
		} else {
			g.setColor(new Color(100, 100, 100));
		}
		
		for(int i = 0; i < borderWidth; i++) {
			g.drawRect(clickRect.getMinX() - (distanceToBorder + i), clickRect.getMinY() - (distanceToBorder + i), clickRect.width() + (distanceToBorder + i) * 2, clickRect.height() + (distanceToBorder + i) * 2);
		}
		
		
		g.setColor(origCol);
		
	}






	public String getFileName() {
		return fileName;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	
	public CustomImageDataII getImage() {
		return image;
	}

	public void setImage(CustomImageDataII newImage) {
		image = newImage;
	}
	
	
	public boolean shouldBePassThru() {
		return shouldBePassThru;
	}
	
	public void setShouldBePassThru(boolean should) {
		shouldBePassThru = should;
	}






	@Override
	public void delete(ScreenObject so) {

		for(int i = 0; i < allCreatedObjects.size(); i++) {
			if(allCreatedObjects.get(i).equals(so)) {
				allCreatedObjects.remove(i);
				return;
			}
		}
		
	}
	
	public void altered() {
		
		int width = image.getDesiredWidth();
		int height = image.getDesiredHeight();
		
		ScreenObject so = null;
		IntRect origRect = null;
		IntRect newRect = null;
		Point center = null;
		
		for(int i = 0; i < allCreatedObjects.size(); i++) {
			so = allCreatedObjects.get(i);
			origRect = so.getClickRect();
			if(origRect.width() == width && origRect.height() == height)
				continue;
			center = origRect.getCenter();
			newRect = new IntRect(center.x - width/2, center.y - height/2, width, height);
			so.setClickRect(newRect);
			if(so instanceof RogueBlockScreenObject) {
				((RogueBlockScreenObject)so).setShouldBePassthru(shouldBePassThru);
			}
				
		}
		
	}
	
}
